/*******************************************************************************
* Copyright (C), 2000-2014,  Sunsky Electronic Technology Co., Ltd.
* 文件名: CCxx00_New.C
* 作  者: 梁新平
* 版  本:
* 日  期: 2014-5-26     
* 说  明:          
*                  
*                  
* 修订历史:        
*                  
*    1. 时间: 2014-5-26
*       修订者: 梁新平
*       修订内容: 创建
*    2.
* 其它:           
*******************************************************************************/

#include "cc2500_1101.h"
#include "platform.h"
#include "function.h"
#include "base_core_user.h"
#include "function_interface.h"


#if defined(CC1101) || defined(CC2500)

//注意CC2500的CRC效验问题－－CRCL=00时会指示CrcErr

//PKTCTRL1=04，即WOR_AUTOSYNC=0,CRC_AUTOFLUSH=0,APPEND_STATUS=1,ADR_CHK=0
//PKTCTRL0=05,即WHITE_DATA=0,PKT_FORMAT=0 used fifo,CRC_EN=1,LENTH=variable

//MCSM1=复位值0x30，即RXOFF_MODE和TXOFF_MODE均为IDLE,
//但CCA_Mode=3 RSSI低而且没有在接收时才能从RX到TX状态，这是测试中1/10概率没有切换到TX状态的原因？改为0

//MDMCFG2从3改为0x13是由FSK转为GFSK模式，相对更好:
//测试出现 按6.6版本76.8K设置时，近距离效果都不行，把FSK改为GFSK就好了
//MCSM0=0x18，即FS_AUTOCAL=Mode1 IDLE->TX,RX时校正

//2010.2.24屏蔽了接收时候直接bRcvOk=1
//2010.2.24可OEM定制无线同步码

//2010.4.8
//CC_PackStatus()读取CCA
//MCSM1=复位值0x30 不再修改为0，使能CCA done
//PKTLEN可以写少于64(原0xFF)避免FIFO溢出，虽然采用不定长包 done
//使用CCA或CS必须要先RXON在接收状态？是的 CCA还必须使能CCA才能检测，CS不需要使能CCA
//IOCFG2 设置为09可在GDO2脚看CCA信号输出 done

//2010.4.16
//测试出CCA比接收完成慢1.7ms，CS载波检测能很快结束

//2010.4.24
//测试RX死机时候，状态还是1接收的，并不是RX溢出，但RXBUF为65字节，刚好比物理BUF多1字节
//重新IDLE再RXON可以退出死机状态，把PKTLEN限定为0x20可以提前结束错误包！！能避免RX死机的情况？
//猜测是长度字节错误导致接收死机，因为GDO0脚一直为高（已经开始接收但没有结束）

//CCA考虑检测时间，要计算发送时间，最末一个CCA后也能发送完整数据包
//因为Calibartion就要720us，及1ms后才能检测到CCA，或考虑去掉自动Calibration?
//CCA的信号强度还可以设置AGCCTRL0-2
//存在能发射，但不能接收到情况？？

//2010.5.12 433M增加修改了BAND2010配置高速无线通信
//2010.5.18 移植到M52时候，修正433M下的原文件，2.4G的配置并不对  --注意:CC_Init()中不同的无线中断打开不同
//5.19 加2.4G下新配置250K-Baud,MSK

//2011.3 肖雪琦移植到STC平台下
//2011.4.9 pei修正sync0,sync1前面漏u8定义导致cc_init()中引导码不对
//2011.5.1 pei不使用SPI操作进行了测试，少许修改SPI1_ReadWriteByte()
//注意：pei STC平台下，SPI操作，必须P1.6保持输出为高，MISO读入才能正确，或者通过P1M1干脆设置为输入

#if 0
#define PAMAX 0xFE 
#define PAMAX2  0xA9  //-4dBm
#define PAMAX3  0x6E  //-8dBm
//#define PAMAX4  0xC6  //-12dBm
#define PAMAX4  0x44  //-28dBm	配对时功率降低，最终使用了-28db的参数
#endif

#define RSSI0  72  //Rssi Offset 


//#define 	FCCCE	


#ifdef CC2500
	#ifdef 	FCCCE
		#define PAMAX 	0xE0 //0xFF 	//1.5
		#define PAMAX2  0xE0 //0xEE  //0dBm
		#define PAMAX3  0xE0 //0x6E  //-8dBm	
	#else
		#define PAMAX 	0xFF 	//1.5
		#define PAMAX2  0xEE  //0dBm
		#define PAMAX3  0xE0 //0x6E  //-8dBm
	#endif
#else
	//cc1101 433M
	#define PAMAX 	0xC0 	//9.9
	#define PAMAX2  0x60  //0dBm
	#define PAMAX3  0x35  //-8dBm
	#define PAMAX4  0x1B  //-16dBm
#endif




//CC2500 BAND2010
// Chipcon
// Product = CC2500
// Chip version = E   (VERSION = 0x03)
// Crystal accuracy = 10 ppm
// X-tal frequency = 26 MHz
// RF output power = 0 dBm
// RX filterbandwidth = 541.666667 kHz
// Phase = 0
// Datarate = 249.938965 kBaud
// Modulation = (7) MSK
// Manchester enable = (0) Manchester disabled
// RF Frequency = 2401.999939 MHz
// Channel spacing = 333.251953 kHz
// Channel number = 0
// Optimization = Sensitivity
// Sync mode = (3) 30/32 sync word bits detected
// Format of RX/TX data = (0) Normal mode, use FIFOs for RX and TX
// CRC operation = (1) CRC calculation in TX and CRC check in RX enabled
// Forward Error Correction = (0) FEC disabled
// Length configuration = (1) Variable length packets, packet length configured by the first received byte after sync word.
// Packetlength = 255
// Preamble count = (2)  4 bytes
// Append status = 1
// Address check = (0) No address check
// FIFO autoflush = 0
// Device address = 0
// GDO0 signal selection = ( 6) Asserts when sync word has been sent / received, and de-asserts at the end of the packet
// GDO2 signal selection = (41) CHIP_RDY

//#include "hw_config.h"
#include "stm32f4xx_hal.h"




//rf
//#define RF_PORT   	GPIOA
//#define RF_CS       GPIO_PIN_4
//#define RF_PAPORT 	GPIOA
//#define RF_PA       GPIO_PIN_2
//#define RF_LNA      GPIO_PIN_1
//#define RF_CS0(rf_id)   HAL_GPIO_WritePin(RF_PORT,RF_CS, GPIO_PIN_RESET)//GPIO_ResetBits(RF_PORT,RF_CS)
//#define RF_CS1(rf_id)   HAL_GPIO_WritePin(RF_PORT,RF_CS, GPIO_PIN_SET)//GPIO_SetBits(RF_PORT,RF_CS)

//#define PA_EN0   HAL_GPIO_WritePin(RF_PAPORT,RF_PA, GPIO_PIN_RESET)//GPIO_ResetBits(RF_PAPORT,RF_PA)
//#define PA_EN1   HAL_GPIO_WritePin(RF_PAPORT,RF_PA, GPIO_PIN_SET)//GPIO_SetBits(RF_PAPORT,RF_PA)

//#define LNA_EN0  HAL_GPIO_WritePin(RF_PAPORT,RF_LNA, GPIO_PIN_RESET)// GPIO_ResetBits(RF_PAPORT,RF_LNA)
//#define LNA_EN1  HAL_GPIO_WritePin(RF_PAPORT,RF_LNA, GPIO_PIN_SET)//GPIO_SetBits(RF_PAPORT,RF_LNA)

//#define RF_READ 		HAL_GPIO_ReadPin(RF_PORT,GPIO_PIN_6)



//hardware 200s RF modual silk screen:J2-J3-J1-J4
GPIO_TypeDef* const rf_cs_port[4]={GPIOD,GPIOB,GPIOD,GPIOC};
uint16_t const rf_cs_pin[4] ={GPIO_PIN_13,GPIO_PIN_4,GPIO_PIN_3,GPIO_PIN_6};

//isr
GPIO_TypeDef* const rf_it_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
uint16_t const rf_it_pin[4] ={GPIO_PIN_14,GPIO_PIN_5,GPIO_PIN_4,GPIO_PIN_7};

//用于设置开关中断
const unsigned char rf_it_pin_nbr[]={14,5,4,7};


//TX PA 5.8G 	//cc2500 RF_LNA
GPIO_TypeDef* const rf_paTX_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
uint16_t const rf_paTX_pin[4] ={GPIO_PIN_11,GPIO_PIN_6,GPIO_PIN_1,GPIO_PIN_4};

//RX PA 5.8G   //cc2500-RF_PA_EN
GPIO_TypeDef* const rf_ce_port[4]={GPIOD,GPIOD,GPIOD,GPIOC};
uint16_t const rf_ce_pin[4] ={GPIO_PIN_12,GPIO_PIN_7,GPIO_PIN_2,GPIO_PIN_5};


#define RF_CS1(id)  	HAL_GPIO_WritePin(rf_cs_port[id],rf_cs_pin[id], GPIO_PIN_SET)
#define RF_CS0(id)   	HAL_GPIO_WritePin(rf_cs_port[id],rf_cs_pin[id], GPIO_PIN_RESET)

#define PA_EN1(id)  	HAL_GPIO_WritePin(rf_ce_port[id],rf_ce_pin[id], GPIO_PIN_SET)
#define PA_EN0(id)   	HAL_GPIO_WritePin(rf_ce_port[id],rf_ce_pin[id],GPIO_PIN_RESET)

#define LNA_EN1(id)  	HAL_GPIO_WritePin(rf_paTX_port[id],rf_paTX_pin[id],GPIO_PIN_SET)
#define LNA_EN0(id)   HAL_GPIO_WritePin(rf_paTX_port[id],rf_paTX_pin[id],GPIO_PIN_RESET)

//#define RF_READ(id) 	HAL_GPIO_ReadPin(rf_it_port[id],rf_it_pin[id])
#define RF_READ(id) 	HAL_GPIO_ReadPin(GPIOA,GPIO_PIN_6)


// miso control
GPIO_TypeDef* const miso_ctrl_port[4]={GPIOE,GPIOB,GPIOE,GPIOE};
uint16_t const miso_ctrl_pin[4] ={GPIO_PIN_8,GPIO_PIN_7,GPIO_PIN_9,GPIO_PIN_10};

#define OPEN_MISO(id)		HAL_GPIO_WritePin(miso_ctrl_port[id],miso_ctrl_pin[id], GPIO_PIN_SET)	
#define CLOSE_MISO(id)	HAL_GPIO_WritePin(miso_ctrl_port[id],miso_ctrl_pin[id], GPIO_PIN_RESET)		



/*
2019.12.04 实测 delay(500) =500us;
环境：主频168MHz,关闭中断,IO取反用示波器测试!!	
由于GPIO无法响应 delayus(1)，所以实际测试delay(500) =500us	*/
void ccxx_delay_us( unsigned short time )
{
    unsigned short i = 0;
    while( time-- ){
			i = 30; 
			while( i-- ) ;
    }
}


//等待芯片ready
static void CC_Rdy(unsigned char rf_id)
{
	unsigned char i;
  for (i=0;i<10;i++){ 
    if( RF_READ(rf_id) ==0) 
    	return; 
    ccxx_delay_us(10);//
		//DelayUs(20);//
  }
 
}

//#define 	SIM_SPI //2020.06.03测试寄存器操作方式ok。
#define		SPI1_BREAK   200
extern SPI_HandleTypeDef hspi1;

static unsigned char SPI1_ReadWriteByte(unsigned char TxData,unsigned char rf_id)
{	
	#ifdef SIM_SPI	
		unsigned short retry=0;	
		if((SPI1->CR1 &SPI_CR1_SPE) != SPI_CR1_SPE){
			/* Enable SPI peripheral */
			SPI1->CR1 |=  SPI_CR1_SPE; //__HAL_SPI_ENABLE(hspi);		
		}
	
		while((SPI1->SR&1<<1)==0){//	等待发送空闲		
			if(retry++>SPI1_BREAK)return 0;
		}			  
		SPI1->DR=TxData;	 	  //发送
		
		retry=0;
		while((SPI1->SR&1<<0)==0){ //等待接收完成 			
			if(retry++>SPI1_BREAK)return 0;
		}	  						    
		return SPI1->DR;          //返回接收到的数据	
		#else
		HAL_StatusTypeDef rlst;
		unsigned char rx_data;		
//		OPEN_MISO(rf_id);			
		rlst =HAL_SPI_TransmitReceive(&hspi1,&TxData,&rx_data,1, 5);
//		CLOSE_MISO(rf_id);		
		if(rlst == HAL_OK)
			return rx_data;
		else 
			return 0;	
		#endif
}



//写命令
static unsigned char CC_Cmd(unsigned char Cmd,unsigned char rf_id)
{
	unsigned char Status;
	
	RF_CS0(rf_id);
	CC_Rdy(rf_id);
	Status=SPI1_ReadWriteByte(Cmd,rf_id);
	RF_CS1(rf_id);	
	return Status;
}



//指定地址，写配置字
static unsigned char CC_WrReg(unsigned char Addr,unsigned char Data,unsigned char rf_id)
{
	unsigned char Status;

  RF_CS0(rf_id);
	CC_Rdy(rf_id);
	Status=SPI1_ReadWriteByte(Addr,rf_id);
	SPI1_ReadWriteByte(Data,rf_id);
	RF_CS1(rf_id);
	return Status;
}
//指定地址，连续写配置
static unsigned char CC_WrRegs(unsigned char Addr,unsigned char *Buf,unsigned char Count,unsigned char rf_id)
{
	unsigned char Status,i;

  RF_CS0(rf_id);
	CC_Rdy(rf_id);
	Status=SPI1_ReadWriteByte(Addr|0x40,rf_id);
	for (i=0;i<Count;i++)
	{ SPI1_ReadWriteByte(Buf[i],rf_id);
	}
	RF_CS1(rf_id);
	return Status;
}



//读状态寄存器
static unsigned char CC_RdStatus(unsigned char Addr,unsigned char rf_id)
{
	unsigned char Data;   
	RF_CS0(rf_id);
	CC_Rdy(rf_id);
	Data=SPI1_ReadWriteByte(Addr|0xC0,rf_id);//
	Data=SPI1_ReadWriteByte(0,rf_id);
	RF_CS1(rf_id);
	return Data;
}


//读配置
static unsigned char CC_RdReg(unsigned char Addr,unsigned char rf_id)
{	
	unsigned char Data;      
	RF_CS0(rf_id);
	CC_Rdy(rf_id);
	Data=SPI1_ReadWriteByte(Addr|0x80,rf_id);
	Data=SPI1_ReadWriteByte(0,rf_id);
	RF_CS1(rf_id);
	return Data;
}
//连续读配置字
static unsigned char CC_RdRegs(unsigned char Addr,unsigned char *Buf,unsigned char Count,unsigned char rf_id)
{
	unsigned char Status,i;

  RF_CS0(rf_id);
	CC_Rdy(rf_id);
	Status=SPI1_ReadWriteByte(Addr|0xC0,rf_id);
	for (i=0;i<Count;i++)
	{ Buf[i]=SPI1_ReadWriteByte(0,rf_id);
	}
	RF_CS1(rf_id);
	return Status;
}


//-------------------------------------------------------------------------

static unsigned char CC_GetStatus(unsigned char rf_id)
{
  return CC_Cmd(CCxxx0_SNOP,rf_id);
}

//芯片上电复位
static void CC_RESET(unsigned char rf_id)
{

   RF_CS1(rf_id);
   ccxx_delay_us(1);//DelayUs(1);
   RF_CS0(rf_id);
   ccxx_delay_us(1);//DelayUs(1);
   RF_CS1(rf_id);
   ccxx_delay_us(1);//DelayUs(50);
   
   CC_Cmd(CCxxx0_SRES,rf_id);
}


static void CC_PaTable(unsigned char paTable,unsigned char rf_id)
{
	CC_Idle(rf_id);//add by Gavin 20210317
  CC_WrReg(CCxxx0_PATABLE, paTable,rf_id);
}

static void CC_Chan(unsigned char Chan,unsigned char rf_id)
{
  CC_Idle(rf_id);//为方便
  CC_WrReg(CCxxx0_CHANNR,Chan,rf_id);
}

void CC_FEC(unsigned char On,unsigned char rf_id)
{
	unsigned char Reg;
  Reg=CC_RdReg(CCxxx0_MDMCFG1,rf_id);
  if (On==1) 
     CC_WrReg(CCxxx0_MDMCFG1, Reg | 0x80,rf_id);
  else
  	 CC_WrReg(CCxxx0_MDMCFG1, Reg & 0x7F,rf_id);
}


static void CC_WHITE(unsigned char On,unsigned char rf_id)
{
	unsigned char Reg;
  Reg=CC_RdReg(CCxxx0_PKTCTRL0,rf_id);
  if (On==1) 
     CC_WrReg(CCxxx0_PKTCTRL0, Reg | 0x40,rf_id);
  else
  	 CC_WrReg(CCxxx0_PKTCTRL0, Reg & 0xBF,rf_id);
}


static void CC_ClrRx(unsigned char rf_id) 
{
  CC_Idle(rf_id);//!!必须在Idle状态
	CC_Cmd(CCxxx0_SFRX,rf_id);
}


static void  CC_ClrTx(unsigned char rf_id) 	
{
  CC_Idle(rf_id);//!!必须在Idle状态
  CC_Cmd(CCxxx0_SFTX,rf_id);
}

void CC_XCal(unsigned char rf_id)
{
  unsigned char i;
  CC_Cmd(CCxxx0_SIDLE,rf_id);
  CC_Cmd(CCxxx0_SCAL,rf_id);
  for (i=0;i<100;i++){ 
		if (CC_RdStatus(CCxxx0_MARCSTATE,rf_id)==1) break;//校正完成
    ccxx_delay_us(10);//DelayUs(10);
  }//for
}




#ifdef CC2500	
RF_SETTINGS rfSettings250K = {
    0x0A,   // FSCTRL1   Frequency synthesizer control.
    0x00,   // FSCTRL0   Frequency synthesizer control.
    0x5C,   // FREQ2     Frequency control word, high byte.
    0x62,   // FREQ1     Frequency control word, middle byte.
    0x76,   // FREQ0     Frequency control word, low byte.
    0x2D,   // MDMCFG4   Modem configuration.
    0x3B,   // MDMCFG3   Modem configuration.
    0x73,   // MDMCFG2   Modem configuration.
    0x23,   // MDMCFG1   Modem configuration.
    0xA4,   // MDMCFG0   Modem configuration.
    0x00,   // CHANNR    Channel number.
    0x00,   // DEVIATN   Modem deviation setting (when FSK modulation is enabled).
    0xB6,   // FREND1    Front end RX configuration.
    0x10,   // FREND0    Front end TX configuration.
    0x18,   // MCSM0     Main Radio Control State Machine configuration.
    0x1D,   // FOCCFG    Frequency Offset Compensation Configuration.
    0x1C,   // BSCFG     Bit synchronization Configuration.
    0xC7,   // AGCCTRL2  AGC control.
    0x00,   // AGCCTRL1  AGC control.
    0xB0,   // AGCCTRL0  AGC control.
    0xEA,   // FSCAL3    Frequency synthesizer calibration.
    0x0A,   // FSCAL2    Frequency synthesizer calibration.
    0x00,   // FSCAL1    Frequency synthesizer calibration.
    0x11,   // FSCAL0    Frequency synthesizer calibration.
    0x59,   // FSTEST    Frequency synthesizer calibration.
    0x88,   // TEST2     Various test settings.
    0x31,   // TEST1     Various test settings.
    0x0B,   // TEST0     Various test settings.
    0x07,   // FIFOTHR   RXFIFO and TXFIFO thresholds.
    0x0E, //29,   // IOCFG2    GDO2 output pin configuration.0x09=CCA输出 0x0E=CS输出
    0x06,   // IOCFG0D   GDO0 output pin configuration. Refer to SmartRF?Studio User Manual for detailed pseudo register explanation.

		0x04,   // PKTCTRL1  Packet automation control.
    0x05,   // PKTCTRL0  Packet automation control.

		0x00,   // ADDR      Device address.
    0x25,//0x20  //FF    // PKTLEN    Packet length.超长包自动结束
};

static void CC_RfConfig(RF_SETTINGS *pRfSettings,unsigned char rf_id) 
{    // Write register settings
    CC_WrReg(CCxxx0_FSCTRL1,  pRfSettings->FSCTRL1,rf_id);
    CC_WrReg(CCxxx0_FSCTRL0,  pRfSettings->FSCTRL0,rf_id);
    CC_WrReg(CCxxx0_FREQ2,    pRfSettings->FREQ2,rf_id);
    CC_WrReg(CCxxx0_FREQ1,    pRfSettings->FREQ1,rf_id);
    CC_WrReg(CCxxx0_FREQ0,    pRfSettings->FREQ0,rf_id);
    CC_WrReg(CCxxx0_MDMCFG4,  pRfSettings->MDMCFG4,rf_id);
    CC_WrReg(CCxxx0_MDMCFG3,  pRfSettings->MDMCFG3,rf_id);
    CC_WrReg(CCxxx0_MDMCFG2,  pRfSettings->MDMCFG2,rf_id);
    CC_WrReg(CCxxx0_MDMCFG1,  pRfSettings->MDMCFG1,rf_id);
    CC_WrReg(CCxxx0_MDMCFG0,  pRfSettings->MDMCFG0,rf_id);
    CC_WrReg(CCxxx0_CHANNR,   pRfSettings->CHANNR,rf_id);
    CC_WrReg(CCxxx0_DEVIATN,  pRfSettings->DEVIATN,rf_id);
    CC_WrReg(CCxxx0_FREND1,   pRfSettings->FREND1,rf_id);
    CC_WrReg(CCxxx0_FREND0,   pRfSettings->FREND0,rf_id);
    CC_WrReg(CCxxx0_MCSM0 ,   pRfSettings->MCSM0 ,rf_id);
    CC_WrReg(CCxxx0_FOCCFG,   pRfSettings->FOCCFG,rf_id);
    CC_WrReg(CCxxx0_BSCFG,    pRfSettings->BSCFG,rf_id);
    CC_WrReg(CCxxx0_AGCCTRL2, pRfSettings->AGCCTRL2,rf_id);
		CC_WrReg(CCxxx0_AGCCTRL1, pRfSettings->AGCCTRL1,rf_id);
    CC_WrReg(CCxxx0_AGCCTRL0, pRfSettings->AGCCTRL0,rf_id);
    CC_WrReg(CCxxx0_FSCAL3,   pRfSettings->FSCAL3,rf_id);
    CC_WrReg(CCxxx0_FSCAL2,   pRfSettings->FSCAL2,rf_id);
		CC_WrReg(CCxxx0_FSCAL1,   pRfSettings->FSCAL1,rf_id);
    CC_WrReg(CCxxx0_FSCAL0,   pRfSettings->FSCAL0,rf_id);
    CC_WrReg(CCxxx0_FSTEST,   pRfSettings->FSTEST,rf_id);
    CC_WrReg(CCxxx0_TEST2,    pRfSettings->TEST2,rf_id);
    CC_WrReg(CCxxx0_TEST1,    pRfSettings->TEST1,rf_id);
    CC_WrReg(CCxxx0_TEST0,    pRfSettings->TEST0,rf_id);
    CC_WrReg(CCxxx0_IOCFG2,   pRfSettings->IOCFG2,rf_id);
    CC_WrReg(CCxxx0_IOCFG0,   pRfSettings->IOCFG0,rf_id);    
    CC_WrReg(CCxxx0_PKTCTRL1, pRfSettings->PKTCTRL1,rf_id);
    CC_WrReg(CCxxx0_PKTCTRL0, pRfSettings->PKTCTRL0,rf_id);
    CC_WrReg(CCxxx0_ADDR,     pRfSettings->ADDR,rf_id);
    CC_WrReg(CCxxx0_PKTLEN,   pRfSettings->PKTLEN,rf_id);

   	CC_WrReg(CCxxx0_FIFOTHR,  pRfSettings->FIFOTHR,rf_id);	
}
#endif 






//==================================================
#ifdef CC1101	//M433M
RF_SETTINGS rfSettings76800 = {
    	0x08,   // FSCTRL1   Frequency synthesizer control.
    	0x00,   // FSCTRL0   Frequency synthesizer control.
    	0x10,   // FREQ2     Frequency control word, high byte.
    	0xA9,   // FREQ1     Frequency control word, middle byte.
    	0x5A,   // FREQ0     Frequency control word, low byte.
    	0xAB,   // MDMCFG4   Modem configuration.
    	0x83,   // MDMCFG3   Modem configuration.
    	0x13,   // MDMCFG2   Modem configuration.
    	0x20,   // MDMCFG1   Modem configuration.
    	0xCF,   // MDMCFG0   Modem configuration. CHANSPC_M
    	0x00,   // CHANNR    Channel number.
    	0x42,   // DEVIATN   Modem deviation setting (when FSK modulation is enabled).
    	0xB6,   // FREND1    Front end RX configuration.
    	0x10,   // FREND0    Front end RX configuration.
    	0x18,   // MCSM0     Main Radio Control State Machine configuration.
    	0x1D,   // FOCCFG    Frequency Offset Compensation Configuration.
    	0x1C,   // BSCFG     Bit synchronization Configuration.
    	0xC7,   // AGCCTRL2  AGC control.
    	0x00,   // AGCCTRL1  AGC control.
    	0xB2,   // AGCCTRL0  AGC control.
    	0xEA,   // FSCAL3    Frequency synthesizer calibration.
    	0x2A,   // FSCAL2    Frequency synthesizer calibration.
    	0x00,   // FSCAL1    Frequency synthesizer calibration.
    	0x1F,   // FSCAL0    Frequency synthesizer calibration.
    	0x59,   // FSTEST    Frequency synthesizer calibration.
    	0x81,   // TEST2     Various test settings.
    	0x35,   // TEST1     Various test settings.
    	0x09,   // TEST0     Various test settings.
    0x07,   // FIFOTHR   RXFIFO and TXFIFO thresholds. //add by Gavin 			
    	0x0E,//0x09,//0x29,   // IOCFG2    GDO2 output pin configuration. 0x09=CCA输出 0x0E=CS输出
    	0x06,   // IOCFG0D   GDO0 output pin configuration. Refer to SmartRF� Studio User Manual for detailed pseudo register explanation.
    	0x04,   // PKTCTRL1  Packet automation control.
    	0x05,   // PKTCTRL0  Packet automation control.
    	0x00,   // ADDR      Device address.
    	0x25,//0x20    // PKTLEN    Packet length.
};


//*------------------------------------------
//* 函数名称 : cc_rf_config
//* 功能描述 : 无线模块配置
//* 入口参数 : 无
//* 出口参数 : 无
//*---------------------------------------------
static void cc_rf_config(RF_SETTINGS *rf_settings,unsigned char rf_id)
{
	// Write register settings
    CC_WrReg(CCxxx0_FSCTRL1,  rf_settings->FSCTRL1,rf_id);
    CC_WrReg(CCxxx0_FSCTRL0,  rf_settings->FSCTRL0,rf_id);
    CC_WrReg(CCxxx0_FREQ2,    rf_settings->FREQ2,rf_id);
    CC_WrReg(CCxxx0_FREQ1,    rf_settings->FREQ1,rf_id);
   	CC_WrReg(CCxxx0_FREQ0,    rf_settings->FREQ0,rf_id);
   	CC_WrReg(CCxxx0_MDMCFG4,  rf_settings->MDMCFG4,rf_id);
   	CC_WrReg(CCxxx0_MDMCFG3,  rf_settings->MDMCFG3,rf_id);
   	CC_WrReg(CCxxx0_MDMCFG2,  rf_settings->MDMCFG2,rf_id);
   	CC_WrReg(CCxxx0_MDMCFG1,  rf_settings->MDMCFG1,rf_id);
   	CC_WrReg(CCxxx0_MDMCFG0,  rf_settings->MDMCFG0,rf_id);
   	CC_WrReg(CCxxx0_CHANNR,   rf_settings->CHANNR,rf_id);
   	CC_WrReg(CCxxx0_DEVIATN,  rf_settings->DEVIATN,rf_id);
   	CC_WrReg(CCxxx0_FREND1,   rf_settings->FREND1,rf_id);
   	CC_WrReg(CCxxx0_FREND0,   rf_settings->FREND0,rf_id);
   	CC_WrReg(CCxxx0_MCSM0 ,   rf_settings->MCSM0 ,rf_id);
   	CC_WrReg(CCxxx0_FOCCFG,   rf_settings->FOCCFG,rf_id);
   	CC_WrReg(CCxxx0_BSCFG,    rf_settings->BSCFG,rf_id);
   	CC_WrReg(CCxxx0_AGCCTRL2, rf_settings->AGCCTRL2,rf_id);
		CC_WrReg(CCxxx0_AGCCTRL1, rf_settings->AGCCTRL1,rf_id);
   	CC_WrReg(CCxxx0_AGCCTRL0, rf_settings->AGCCTRL0,rf_id);
   	CC_WrReg(CCxxx0_FSCAL3,   rf_settings->FSCAL3,rf_id);
   	CC_WrReg(CCxxx0_FSCAL2,   rf_settings->FSCAL2,rf_id);
		CC_WrReg(CCxxx0_FSCAL1,   rf_settings->FSCAL1,rf_id);
   	CC_WrReg(CCxxx0_FSCAL0,   rf_settings->FSCAL0,rf_id);
   	CC_WrReg(CCxxx0_FSTEST,   rf_settings->FSTEST,rf_id);
   	CC_WrReg(CCxxx0_TEST2,    rf_settings->TEST2,rf_id);
   	CC_WrReg(CCxxx0_TEST1,    rf_settings->TEST1,rf_id);
   	CC_WrReg(CCxxx0_TEST0,    rf_settings->TEST0,rf_id);
   	CC_WrReg(CCxxx0_IOCFG2,   rf_settings->IOCFG2,rf_id);
   	CC_WrReg(CCxxx0_IOCFG0,   rf_settings->IOCFG0,rf_id);    
   	CC_WrReg(CCxxx0_PKTCTRL1, rf_settings->PKTCTRL1,rf_id);
   	CC_WrReg(CCxxx0_PKTCTRL0, rf_settings->PKTCTRL0,rf_id);
   	CC_WrReg(CCxxx0_ADDR,     rf_settings->ADDR,rf_id);
   	CC_WrReg(CCxxx0_PKTLEN,   rf_settings->PKTLEN,rf_id);
//#ifdef BAND2010
   	CC_WrReg(CCxxx0_FIFOTHR,  rf_settings->FIFOTHR,rf_id);
//#endif	
}

#endif //#ifdef CC1101




//====================================================================



//u8 CC_RssiCh(u8 rssi)
//{//输出值是正值，但都是负的dBm，例如返回值是55是-55dBm
//  if (rssi>=128)
//  { return (128+RSSI0-(rssi>>1));
//  }else
//  { return (RSSI0-(rssi>>1));
//  }
//}

/*

*/
unsigned char cc2500_get_rssi(unsigned char rf_id)
{	
	unsigned char rssi =CC_RdStatus(CCxxx0_RSSI,rf_id);

  if (rssi>=128)
   return (128+RSSI0-(rssi>>1));
  else
   return (RSSI0-(rssi>>1));  	
}


//u8 CC_PackStatus(void)
//{
//  return CC_RdStatus(CCxxx0_PKTSTATUS);
//  //bit0-bit7 GDO0,GDO1,GDO2,SYNC,  CCA,PQT,CS,CRCOK
//  //如果MCSM1.CCA＝0没有使用CCA的话，CCA指示位总为1，
//  //如果使用CCA，CCA和CS位就相反
//}

void rf_set_PA_Mode(unsigned char mode,unsigned char rf_id)
{
   	switch (mode)
   	{
     	case 2:
	 	   	CC_PaTable(PAMAX2,rf_id);
		   	break;
	 	case 3:
	 	   	CC_PaTable(PAMAX3,rf_id);
		   	break;
//	 	case 4:
//	 	   	CC_PaTable(PAMAX4,rf_id);
//		   	break;
	 	default:
	 	   	CC_PaTable(PAMAX,rf_id);
		   	break;	   	   
   }
}



unsigned char test_only;

void rf_SendPacket(unsigned char *txBuffer, unsigned char size,unsigned char rf_id) 	
{	
	LNA_EN0(rf_id);
	PA_EN1(rf_id);
	
	CC_ClrTx(rf_id);//v1.1保证TxBYTES无以前字节
  CC_WrReg(CCxxx0_TXFIFO, size,rf_id);//len
	CC_WrRegs(CCxxx0_TXFIFO, txBuffer, size,rf_id);
	CC_Cmd(CCxxx0_STX,rf_id);
}



//static void cc_freq(unsigned char freq, unsigned char rfpwr)
//{
////	    //换片选...
////#ifndef CHAN80
////	#ifdef CC1101		
////		CC_Chan(freq-1); //add by Gavin 
////	#else	
////  	 CC_Chan(freq*6);
////	#endif 
////#else
////	  if (freq<41){ 
////			CC_Chan(freq*6);// 1-40是双数频点 2402-2480
////  	}
////		else{ 
////			freq=3+(freq-41)*6; // 41-80是奇数频点 2401-2479
////			CC_Chan(freq);
////  	}
////#endif
//}

void rf_setfreq(unsigned char freq,unsigned char rf_id)
{
#ifdef CC2500
	  if (freq<41){ 
			CC_Chan(freq*6,rf_id);// 1-40是双数频点 2402-2480
  	}
		else{ 
			freq=3+(freq-41)*6; // 41-80是奇数频点 2401-2479
			CC_Chan(freq,rf_id);
  	}
#elif defined(CC1101)		
		CC_Chan(freq-1,rf_id); //add by Gavin
#endif
	
  	//cc_set_pa(rfpwr);//基站功率		
  	CC_XCal(rf_id);
}




#define 	MAX_LEN		40

//从无线模块读取数据包
static unsigned char cc_rd_packet(unsigned char *buf,unsigned char rf_id)
{	
	volatile unsigned char crc_ok=0;
     
	// Read length byte
	buf[0]= CC_RdReg(CCxxx0_RXFIFO,rf_id);//第一字节是Len
  if( (buf[0]==0)||(buf[0]>MAX_LEN) ) 
		goto RXERR;
	 
  // Read data from RX FIFO and store in rxBuffer
  CC_RdRegs(CCxxx0_RXFIFO, buf+1, buf[0],rf_id); 
   
  // Read the 2 appended status bytes (status[0] = RSSI, status[1] = LQI)
  //rssi= 
	CC_RdReg(CCxxx0_RXFIFO,rf_id);
  //lqi=CC_RdReg(CCxxx0_RXFIFO);
  //if (lqi>0x80)
	if(CC_RdReg(CCxxx0_RXFIFO,rf_id)>0x80)	
	{ 
	 	crc_ok=1;	// MSB of LQI is the CRC_OK bit	   	
	}
	else 
		crc_ok=0;
	
//  lqi=lqi&0x7F;			 
	//len=
	//CC_RdStatus(CCxxx0_RXBYTES) & 0x7f;//mask by Gavin
//	if (len==0) 
//	 	return ;
	
RXERR:	 //应该为0，不为0就不对，要清除RxFiFo
	CC_ClrRx(rf_id);

	return crc_ok;
}


extern void rf_modual__tx_interrupt_counter(unsigned char id);

//--------------------------------------------------------
//无线模块中断服务程序
void rf_Irq(unsigned char rf_id)	
{
	volatile unsigned char i;
	unsigned char tmp[64+1];
	
	PA_EN0(rf_id);
  LNA_EN1(rf_id);	
	
	//先处理模块错误情况
	i=CC_RdStatus(0x35,rf_id)&0x7f;//CCxxx0_MARCSTATE
	if (i==17)
	{CC_ClrRx(rf_id);goto TRXRET;}//Rx_OverFlow错误
	
	if (i==22) 
	{CC_ClrTx(rf_id);goto TRXRET;}//Tx_UnderFlow错误
	
	
	//根据是否接收到数据，判断是发送完成中断还是接收中断
	i=CC_RdStatus(0x3B,rf_id)&0x7f;//CCxxx0_RXBYTES	
	if(i==0){ //发送中断
		rf_modual__tx_interrupt_counter(rf_id);
	}		
	else{
		
		tmp[32]=0;
		tmp[33]=0;		
		if( cc_rd_packet(tmp+1,rf_id) ){						
			
			tmp[0] = rf_id;	//record INT id
			base_core.rf_data_fifo_in(tmp); //keypad_rf_data_save(tmp);
						
		}//if			
	}

	
TRXRET:		
  	CC_RxOn(rf_id);	 //rx 
}



/*
设置同步码
*/
void rf_set_syncode(unsigned short sync,unsigned char rf_id)
{
//    uint8_t addr[5] = {INIT_ADDR};	//#define INIT_ADDR           0x19,0x98,0xA4,0x25,0x01
//    addr[2] = sync>>8;
//    addr[3] = sync; 		//修改无线地址码，缺省A425
//    NRF24L01_Set_TxAddr( addr, 4 );         //设置TX地址
//    NRF24L01_Set_RxAddr( 0,addr, 4 );      //设置RX地址 通道0

  CC_WrReg(CCxxx0_SYNC1,sync,rf_id);
  CC_WrReg(CCxxx0_SYNC0,sync>>8,rf_id);	
}

unsigned char CC_Test(unsigned char rf_id)
{ 
   return CC_RdStatus(CCxxx0_VERSION,rf_id);//0x03
}

unsigned char ver_val;

//************************
void  rf_initial(unsigned char rf_id)
{
	//打开无线模块spi miso控制开关!以后都不关闭!!
	OPEN_MISO(rf_id);	
	
	CC_RESET(rf_id);	
#ifdef CC1101	//add by Gavin 
	cc_rf_config(&rfSettings76800,rf_id);
#else	
	CC_RfConfig(&rfSettings250K,rf_id);
#endif

	ver_val =CC_Test(rf_id);
	
  rf_set_syncode(0x25A4,rf_id);//actual test OK!
	
	CC_PaTable(PAMAX,rf_id);
  CC_WrReg(CCxxx0_MCSM1,0x00,rf_id );//0x0f取消CCA，收发总回到RX 不能，否则不能自动校正频率
  CC_WrReg(CCxxx0_MCSM0,0x38,rf_id );//MCSM).FS_AUTOCAL 0x18总Calibatre，0x28 IDLE时候，0x38 4次IDLE校正一次
  CC_WHITE(1,rf_id);

#ifdef CC1101	
	CC_FEC(1,rf_id); //add by Gavin 
#endif 
	
  CC_RxOn(rf_id);
  //PA控制
  LNA_EN1(rf_id);
 	PA_EN0(rf_id);
}




//-------- FCC CE start --------------------------------------------
#ifdef FCCCE

/*


*/
static void FCC_Init(void )
{
	extern TIM_HandleTypeDef htim2;	
	extern TIM_HandleTypeDef htim5;	
	HAL_TIM_Base_MspDeInit(&htim2);	
	HAL_TIM_Base_MspDeInit(&htim5);			
}	

extern unsigned char base_test_chan;
//认证需要的特殊测试模式
//1 连续发射模式（带调制）
//2 连续收信模式（带调制）
//3 无调制 连续发信模式
//4 无调制 连续收信模式
void FCC_test_enter(unsigned char mode,unsigned char rf_id)
{
	FCC_Init();
	CC_Cmd(CCxxx0_SIDLE,0);
	CC_Cmd(CCxxx0_SIDLE,1);	
	CC_Cmd(CCxxx0_SIDLE,2);
	CC_Cmd(CCxxx0_SIDLE,3);
	rf_setfreq(base_test_chan,rf_id);
	
	
  switch (mode){
		
   	case 1://连续MSK输出
	 	PLATFORM_DISABLE_IRQ();//CLI();//关中断
   		CC_Cmd(CCxxx0_SIDLE,rf_id);
   		//cc_write_reg(0x08,0x02 );//CCxxx0_PKTCTRL0 持续发射测试功率
		  CC_WrReg(0x08,0x22,rf_id);	//使用随机数据发送，保证有数据出去
		  //写回标准MSK
		  CC_WrReg(0x12,0x73,rf_id );//CCxxx0_MDMCFG2
		  CC_WrReg(0x22,0x10,rf_id );//CCxxx0_FREND0

		  //cc_write_reg(0x11,0x7A );	//MDMCFG3 baud调高可以过500KHz

   		LNA_EN0(rf_id);
	    PA_EN1(rf_id);
	    CC_Cmd(CCxxx0_STX,rf_id);
		
		  PLATFORM_ENABLE_IRQ();//SEI();		//开中断
		  break;
	
	case 2://连续MSK接收
	    PLATFORM_DISABLE_IRQ();//CLI();		//关中断
		  CC_Cmd(CCxxx0_SIDLE,rf_id);
		  CC_WrReg(0x08,0x02,rf_id );//CCxxx0_PKTCTRL0 持续发射测试功率
		  //写回标准MSK
		  CC_WrReg(0x12,0x73,rf_id );//CCxxx0_MDMCFG2
   		CC_WrReg(0x22,0x10,rf_id );//CCxxx0_FREND0
	 	  
	    PA_EN0(rf_id);
	    LNA_EN1(rf_id);
	    CC_Cmd(CCxxx0_SRX,rf_id);
	
		  PLATFORM_ENABLE_IRQ();//SEI();		//开中断
	    break;	  
	
	case 3://连续载波输出，无调制
		  PLATFORM_DISABLE_IRQ();//CLI();		//关中断
   		CC_Cmd(CCxxx0_SIDLE,rf_id);
   		//以下2行用于KCC测试，只出载波，未调制的---注意：SPAN设1M，VBW1M，但RBW设10K才能看到分开的2个波峰
   		CC_WrReg(0x12,0x33,rf_id );//CCxxx0_MDMCFG2
   		CC_WrReg(0x22,0x00,rf_id );//CCxxx0_FREND0
		  CC_WrReg(0x08,0x02,rf_id );//CCxxx0_PKTCTRL0 持续发射测试功率
	
   		LNA_EN0(rf_id);
	    PA_EN1(rf_id);
	    CC_Cmd(CCxxx0_STX,rf_id);

		  PLATFORM_ENABLE_IRQ();//SEI();		//开中断
		  break;
	
	case 4://连续载波模式接收，无调制	
	    PLATFORM_DISABLE_IRQ();//CLI();		//关中断
   		CC_Cmd(CCxxx0_SIDLE,rf_id);
   		//以下2行用于KCC测试，只出载波，未调制的---注意：SPAN设1M，VBW1M，但RBW设10K才能看到分开的2个波峰
   		CC_WrReg(0x12,0x33,rf_id );//CCxxx0_MDMCFG2
   		CC_WrReg(0x22,0x00,rf_id );//CCxxx0_FREND0
		  CC_WrReg(0x08,0x02,rf_id );//CCxxx0_PKTCTRL0 持续发射测试功率
   		
	    PA_EN0(rf_id);
	    LNA_EN1(rf_id);
	    CC_Cmd(CCxxx0_SRX,rf_id);
		  
		  PLATFORM_ENABLE_IRQ();//SEI();		//开中断  
	 	  break;	  	  
   }//sw
	 
	 
}
#endif
//-------- FCC CE stop --------------------------------------------




#endif //CCxxxx


